******************************************************
* MESSAGE.SRC                                        *
*                                                    *
* This program sends a message to the console ten    *
* times on ten separate lines.  The program includes *
* OUTSTR and OUTCHR subroutines.                     *
******************************************************
DUART    EQU      $C001    ;68681 base address
SRA      EQU      1*2      ;status register A
TBA      EQU      3*2      ;Tx buffer A
CR       EQU      $0D      ;ASCII carriage return
LF       EQU      $0A      ;ASCII line feed

         ORG      $8000
MESSAGE  MOVE.W   #9,D7           ;use D7 as counter
LOOP     MOVEA.L  #TEXT,A1        ;A1 ---> message
         BSR.S    OUTSTR          ;send it
         DBRA     D7,LOOP         ;repeat until done
         TRAP     #14             ;exit

******************************************************
* OUTCHR - OUTput CHaRacter in D0 to serial port     *
*                                                    *
*        ENTER:   D0[0:8] contains ASCII character   *
*        EXIT:    D0[0:8] unchanged                  *
*                 D0[8:31] cleared                   *
*        USES:    no subroutines                     *
******************************************************
OUTCHR   MOVE.L   A0,-(A7)       ;save A0
         MOVE.W   D7,-(A7)       ;save D7
         MOVEA.L  #DUART,A0      ;A0 points to 68681
OUTCHR2  MOVE.B   SRA(A0),D7     ;get port A status
         ANDI.B   #4,D7          ;buffer empty?
         BEQ.S    OUTCHR2        ;no:  check again
         MOVE.B   D0,TBA(A0)     ;yes: send char.
         MOVE.W   (A7)+,D7       ;restore D7
         MOVE.L   (A7)+,A0       ;restore A0
         RTS

******************************************************
* OUTSTR - OUTput null-terminated STRing             *
*                                                    *
*        ENTER:   A1 points to string                *
*        EXIT:    A1 points to null-terminator       *
*        USES:    OUTCHR                             *
******************************************************
OUTSTR   MOVE.L   D0,-(A7)       ;save D0 on stack
OUTSTR2  MOVE.B   (A1)+,D0       ;get character
         BEQ.S    EXIT           ;if null byte, done
         BSR.S    OUTCHR         ;send it
         BRA.S    OUTSTR2        ;repeat
EXIT     MOVE.L   (A7)+,D0       ;restore D0
         RTS

TEXT     DC.B     CR,LF,'Assembly language programming'
         DC.B     ' is fun',0
         END      MESSAGE
*~Font name~Courier New~
*~Font size~10~
*~Tab type~1~
*~Tab size~8~
